import logging
import os

# set acceleras default logger
from hailo_model_optimization.acceleras.utils.logger import default_logger
from hailo_model_optimization.acceleras.utils.nvidia_smi_gpu_selector import select_least_used_gpu

logger = default_logger()

# disable tensorflow
logging.getLogger("tensorflow").setLevel(logging.ERROR)
os.environ["KMP_AFFINITY"] = "noverbose"
os.environ["TF_CPP_MIN_LOG_LEVEL"] = "3"

# disable gpu allocation from TF
if os.environ.get("HAILO_SET_MEMORY_GROWTH", "1").lower() in {"true", "1", "yes", "t"}:
    os.environ["TF_FORCE_GPU_ALLOW_GROWTH"] = "true"

# GPU selection logic before importing TensorFlow
if "CUDA_VISIBLE_DEVICES" not in os.environ:
    gpu = select_least_used_gpu()
    if gpu is not None:
        os.environ["CUDA_VISIBLE_DEVICES"] = gpu
    else:
        os.environ["CUDA_VISIBLE_DEVICES"] = "99"
        logger.info("No GPU chosen and no suitable GPU found, falling back to CPU.")

import tensorflow as tf  # noqa: E402

tf.autograph.set_verbosity(0, alsologtostdout=False)
tf_logger = tf.get_logger()
tf_logger.setLevel("ERROR")
tf_logger.disabled = True

# disable absl-py
import absl.logging as absll  # noqa: E402

absll.set_verbosity(absll.FATAL)
absll._absl_handler = None
absll._warn_preinit_stderr = False
