from abc import ABC

from hailo_model_optimization.acceleras.atomic_ops.base_atomic_op import BaseAtomicOp


class BaseNonArithmeticAtomicOp(BaseAtomicOp, ABC):
    """
    Describes a non arithmetic atomic op. This calls is an interface for all the ops that have no arithmetic
    operations. Any non arithmetic op should inherent from this class.

    """

    def __init__(self, name: str, logger=None, fully_native=None, **kwargs):
        super().__init__(name, logger=logger, fully_native=fully_native, **kwargs)

    def create_weight_quant_element(self, **kwargs):
        # Non arithmetic ops shouldn't have any weights
        pass

    def enable_lossy(self, **kwargs):
        """Force NO lossy operation.."""

    def disable_lossy(self, **kwargs):
        pass

    def create_hw_params(self, **kwargs):
        """NO quantization.."""

    def call_hw_sim(self, inputs, **kwargs):
        return self.call_native(inputs, **kwargs)

    def export_weights(self):
        return dict()

    @property
    def bit_exact_supported(self) -> bool:
        """This layer supports bit exact emulation."""
        return True
