from abc import ABC, abstractmethod

from hailo_model_optimization.acceleras.hailo_layers.base_acceleras_layer import BaseAccelerasLayer
from hailo_model_optimization.acceleras.utils.acceleras_definitions import OpStates


class BaseOp(BaseAccelerasLayer, ABC):
    """
    Abstract class declaring the API that all our composite and atomic ops will expose,
    adding numerics-handling extensions on top of keras.layers' usual build() & call().

    This class serves as a reminded to keep Atomic and Composite layers named similarly for good order,
     though currently this is not strictly necessary since we no longer have polymorphic APIs
     (well, their comeback is possible:) )

    TODO consider deprecating the whole class..
    """

    def __init__(self, name, logger=None, **kwargs):
        super().__init__(name=name, logger=logger, **kwargs)
        self.supported_states = {OpStates.FP}

    @abstractmethod
    def enable_lossy(self, **kwargs):
        """
        OVERRIDE in subclasses with whatever is needed to switch to lossy target
        - either the default or externally specified by bitreducers arg(s)
        """

    @abstractmethod
    def disable_lossy(self, **kwargs):
        """
        OVERRIDE in subclasses with whatever is needed to switch to lossless
        """

    @abstractmethod
    def start_stats_collection(self):
        pass

    @abstractmethod
    def stop_stats_collection(self):
        pass

    def import_weights(self, *args, **kwargs):
        """
        [optionally] OVERRIDE in subclasses with whatever is needed to
         set all pre-trained parameters for the operation.
        Note that all ops also inherit keras.Layer's "set_weights" - but that API expects a flat list,
          synced to creation order. We don't encourage it's usage
          and prefer this explicit (albeit layer-specific) method. Can skip in weightless layers..
        """

    def create_hw_params(self, *args, **kwargs):
        """
        [optionally] OVERRIDE in subclasses with a calculation of numerization params for quantization
        """
