import numpy as np

from hailo_model_optimization.acceleras.atomic_ops.reduce_sum_op import ReduceSumOp


class ReduceMeanOp(ReduceSumOp):
    """
    This class emulates the reduce mean operation
    """

    def __init__(self, name: str, groups=1, reduce_axes=3, logger=None, fully_native=None, **kwargs):
        super().__init__(
            name,
            logger=logger,
            fully_native=fully_native,
            groups=groups,
            reduce_axes=reduce_axes,
            **kwargs,
        )

    def _build(self, input_shape):
        """
        the kernel for reduce_mean will be the same as reduce sum - but devided by _input_group_size
        """
        super()._build(input_shape)
        self.kernel = np.sign(self.kernel) / self._input_group_size

    @property
    def op_name(self):
        return "reduce_mean"
