from dataclasses import dataclass
from enum import Enum
from typing import Callable, Optional, Tuple


class EncodingType(Enum):
    Scale = "scale"
    ZeroPoint = "zero_point"
    Dummy = "dummy"


@dataclass
class EncodingNode:
    encoding_type: EncodingType = EncodingType.Dummy
    """The type of the encoding."""

    scalar: Optional[bool] = None
    """Whether the represented encoding should be a scalar."""

    shape: Optional[Tuple[int]] = None
    """The shape of the represented encoding."""

    initializer: Optional[Callable] = None
    """Encoding initializer instance (callable)."""

    regularizer: Optional[Callable] = None
    """Encoding regularizer instance (callable)."""

    constraint: Optional[Callable] = None
    """Encoding constraint instance (callable)."""

    quant: bool = False
    """Whether the encoding should be represented by an integer (will pass str)."""

    quant_min: Optional[float] = None
    quant_max: Optional[float] = None
