from typing import Tuple

from hailo_model_optimization.acceleras.atomic_ops.padding_op import PaddingOp
from hailo_model_optimization.acceleras.hailo_layers.base_hailo_single_atomic import BaseHailoSingleAtomic
from hailo_model_optimization.acceleras.utils.acceleras_definitions import (
    DEFAULT_PADDING_NEG_INF_VALUE,
    EquivClassification,
    LayerHandlerType,
    LayerType,
)


class HailoExternalPad(BaseHailoSingleAtomic):
    """Represents `external padding` layer in the hn"""

    _hn_type = LayerType.EXTERNAL_PAD
    OP_NAME = "padding_op"

    def __init__(
        self,
        name: str,
        padding: Tuple[int, int, int, int, int, int],
        logger=None,
        **kwargs,
    ):
        padding_op = PaddingOp(
            name=f"{name}/{self.OP_NAME}",
            padding=padding,
            logger=logger,
        )
        super().__init__(name=name, core_op=padding_op, logger=logger, **kwargs)

    @classmethod
    def from_hn(cls, lname, hn_element, logger=None):
        external_pad_params = hn_element["params"]["external_pad_params"]
        layer = cls(
            name=lname,
            padding=external_pad_params,
            logger=logger,
        )
        layer.finalize_from_hn(hn_element)
        return layer

    def get_equalization_handler_type(self, predecessor_index=None):
        features_padding = self.atomic_op.padding[4] != 0 or self.atomic_op.padding[5] != 0
        non_trivial_padding_const_value = self.atomic_op.padding_const_value not in [0, DEFAULT_PADDING_NEG_INF_VALUE]
        if features_padding or non_trivial_padding_const_value:
            type_handler = LayerHandlerType.unsupported
        else:
            type_handler = LayerHandlerType.transparent
        return EquivClassification(type_handler, is_source=False)
