import tensorflow as tf

from hailo_model_optimization.acceleras.hailo_layers.base_hailo_none_nn_core_layer import BaseHailoNonNNCoreLayer


class HailoNonNNCoreOutputLayer(BaseHailoNonNNCoreLayer):
    """
    Represents output of none-nn-core layer in the hn

    Args:
        name: layer name
        input shapes: input shapes of the layer
        logger: the logger for the class

    """

    def __init__(self, name: str, input_shapes: list, output_shapes: list, logger=None, **kwargs):
        super().__init__(name=name, input_shapes=input_shapes, output_shapes=output_shapes, logger=logger, **kwargs)

    @classmethod
    def from_hn(cls, lname, hn_element, logger=None):
        input_shapes = hn_element.get("input_shapes", [])
        output_shapes = hn_element.get("output_shapes", [])
        layer = cls(name=lname, input_shapes=input_shapes, output_shapes=output_shapes, logger=logger)
        layer.finalize_from_hn(hn_element)
        return layer

    def call_core(self, inputs, training=False, **kwargs):
        return tf.identity(inputs)
