from hailo_model_optimization.acceleras.hailo_layers.hailo_depthwise import HailoDepthwise
from hailo_model_optimization.acceleras.utils.acceleras_definitions import LayerType, PrecisionMode


class HailoNormalization(HailoDepthwise):
    """
    Our normalization layer is a mock dw for post training inference
    (rather than actual normalization layer)
    """

    SUPPORTED_PRECISION_MODE = {
        PrecisionMode.a8_w8,
        PrecisionMode.a8_w4,
        PrecisionMode.a16_w16,
        PrecisionMode.a8_w4_a8,
        PrecisionMode.a8_w4_a16,
        PrecisionMode.a8_w8_a8,
        PrecisionMode.a8_w8_a16,
        PrecisionMode.a16_w16_a16,
        PrecisionMode.a16_w16_a8,
    }

    _hn_type = LayerType.NORMALIZATION

    @classmethod
    def get_default_params(cls):
        # TODO: this is temporary solution until we have pydantic scheme
        defaults = super().get_default_params()
        defaults["kernel_shape"] = [1, 1, 1, 1]
        return dict(defaults)
