from hailo_model_optimization.acceleras.atomic_ops.passthru_op import PassthruOp
from hailo_model_optimization.acceleras.hailo_layers.base_hailo_single_atomic import BaseHailoSingleAtomic
from hailo_model_optimization.acceleras.utils.acceleras_definitions import (
    EquivClassification,
    LayerHandlerType,
    LayerType,
    OptimizationTarget,
    PrecisionMode,
)


class HailoShortcut(BaseHailoSingleAtomic):
    """
    Represents `shortcut` layer in the hn.
    This layer is usually used as a buffer layer.

    Args:
         name: layer name
         logger: the logger for the class
         **kl_kwargs:

    """

    _hn_type = LayerType.SHORTCUT
    OP_NAME = "passthru_op"

    def __init__(self, name: str, logger=None, **kwargs):
        passthru_op = PassthruOp(f"{name}/{self.OP_NAME}", fully_native=True, logger=logger)
        super().__init__(name=name, core_op=passthru_op, logger=logger, **kwargs)

        self.encoding_const = False

    @classmethod
    def from_hn(cls, lname, hn_element, logger=None):
        layer = cls(
            name=lname,
            logger=logger,
        )
        layer.finalize_from_hn(hn_element)
        return layer

    def get_equalization_handler_type(self, predecessor_index=None):
        return EquivClassification(LayerHandlerType.transparent, is_source=False)

    def get_quarot_handler_type(self, predecessor_index=None):
        return EquivClassification(LayerHandlerType.transparent, is_source=False)

    def _get_precision_mode_supported_in_hw(self, arch):
        if arch in {OptimizationTarget.MERCURY, OptimizationTarget.SAGE, OptimizationTarget.PLUTO}:
            return {PrecisionMode.a8_w8_a8, PrecisionMode.a16_w16_a16, PrecisionMode.a8_w8, PrecisionMode.a16_w16}
        else:
            return super()._get_precision_mode_supported_in_hw(arch)

    @property
    def is_precision_transparent(self) -> bool:
        return True
