import tensorflow as tf

from hailo_model_optimization.acceleras.lossy_elements.base_lossy_element import BaseLossyElement


class IdentityElement(BaseLossyElement):
    # a bit reducer that is always lossles
    def lossy_call(self, inp, training=False):
        return tf.identity(inp)

    def enable(self):
        pass

    def _is_eq(self, other):
        return True

    def __str__(self):
        return "id"

    @classmethod
    def from_config(cls, config):
        valid_kwargs = {
            "name": config.pop("name"),
        }
        instance = cls(**valid_kwargs)

        return instance
