from copy import copy

from hailo_model_optimization.acceleras.model.preprocess.conversion import get_conversion_callback


def add_preprocess(model):
    preprocess_dict = {}
    for input_name in model.flow.input_nodes:
        input_layer = model.layers[input_name]
        if input_layer.emulate_conversion:
            preprocess_dict[input_layer] = get_conversion_callback(
                input_layer.conversion_type, conversion_weights=input_layer.conversion_weights
            )

    def _model_preprocess(inputs: dict) -> dict:
        inputs = copy(inputs)
        for input_layer_, conversion_func in preprocess_dict.items():
            inputs[input_layer_.full_name] = conversion_func(
                inputs[input_layer_.full_name], input_layer_.input_spec.shape
            )
        return inputs

    model.preproc_cb = _model_preprocess
