from abc import ABC, abstractmethod

from hailo_model_optimization.acceleras.hailo_layers.base_acceleras_layer import BaseAccelerasLayer


class BaseNativeLayer(BaseAccelerasLayer, ABC):
    name: str

    def __init__(self, name, logger=None) -> None:
        super().__init__(name=name, logger=logger)

    @abstractmethod
    def import_weights(self, params: dict) -> None:
        pass

    @abstractmethod
    def export_weights(self) -> dict:
        pass

    @abstractmethod
    def call(self, inputs):
        pass

    @classmethod
    @abstractmethod
    def from_hn(cls, lname: str, hn_element: dict, logger=None):
        """
        OVERRIDE in subclasses with whatever is needed to create instance from an HN slice
        """

    def get_inputs_data_path(self) -> list:
        return []

    def import_translation_config(self, translation_config):
        pass

    def verify_config(self, precision_config):
        pass

    def create_quant_element_by_data_path(self, data_path, bits):
        pass

    def create_quant_element_custom_behavior(self, precision_config, optimization_target):
        pass

    @property
    def atomic_ops(self):
        return []
