from typing import Dict, List, Tuple

import numpy as np

from hailo_model_optimization.acceleras.atomic_ops.base_atomic_op import BaseAtomicOp
from hailo_model_optimization.acceleras.utils.acceleras_exceptions import AccelerasException


def add_sufix_to_keys(params: Dict[str, np.ndarray], keys: Tuple[str], suffix: str) -> Dict[str, np.ndarray]:
    """Helper funtion to add sufix to keys"""
    return {(key + suffix if key in keys else key): value for key, value in params.items()}


def generic_ops_hw_params_export(atomic_ops: List[BaseAtomicOp]) -> Dict[str, np.ndarray]:
    """Generic export of Ops hw Params, this will be use for layers that asume all the ops
    on the layer are unique, Most of the layers are like this where we have some input, a conv op, then
    a bias, and then an activation and some other op on the mix
    #! This CODE is not on the base because, the are layers than have multiple inherence and their export might change.
    #! this way they all can have the same Code if they want to use the generic Code.
    """
    params = dict()
    for op in atomic_ops:
        if not op.is_weights_lossy:
            raise AccelerasException(
                f"{op.name} Weights should be lossy. "
                "Please enable lossy mode explicitly before exporting hw params using enable_lossy() or set_lossy()"
            )
        params.update(op.export_hw_params())
    return params
