from contextlib import contextmanager
from logging import Logger
from pathlib import Path
from typing import Union

import yaml

from hailo_model_optimization.acceleras.model.hailo_model.hailo_model import HailoModel
from hailo_model_optimization.acceleras.utils.flow_state.flow_state_updater import FlowStateUpdater

FlowCommands = Union[str, Path, dict, None]


def update_model_state(model: HailoModel, flow_commands: FlowCommands, logger: Logger):
    """Funtion Updates the State of the model, base on the file given, this funtion does some check to the file
    and then run the commands"""
    if flow_commands is None:
        return

    if isinstance(flow_commands, dict):
        commnads = flow_commands

    elif isinstance(flow_commands, (str, Path)):
        file_path = Path(flow_commands)
        if not file_path.exists():
            raise FileExistsError(
                f"Given File path: {file_path} for the flow commands does not exist, please make sure to supply "
                "a correct path to a configuration file, for the model infer modifications."
            )

        with file_path.open() as fp:
            logger.info(f"Model will load infer modifications from {file_path}.")
            commnads = yaml.safe_load(fp)
    else:
        raise TypeError("Flow commands given is not a supported type")

    FlowStateUpdater(model, logger).load_params(commnads).run()


@contextmanager
def modify_flow_state(model: HailoModel, flow_commands: FlowCommands, logger: Logger):
    """Funtion Updates the State of the model, base on the file given, this funtion does some check to the file
    and then run the commands"""

    current_state = model.export_flow_state()
    update_model_state(model, flow_commands, logger)
    try:
        yield model
    finally:
        model.import_flow_state(current_state)
