import importlib.util
import os

import tensorflow as tf
from future.utils import with_metaclass


class Singleton(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super().__call__(*args, **kwargs)
        return cls._instances[cls]


class HSimWrapper(with_metaclass(Singleton, object)):
    def __init__(self):
        self._hsim = None

    def load(self):
        if self._hsim is None:
            self._load()

    def _load(self):
        sdk_client_path = importlib.util.find_spec("hailo_sdk_client")
        if sdk_client_path is None:
            return
        hsim_path = os.path.join(os.path.dirname(sdk_client_path.origin), "emulator/emulator/lib/HSim.so")
        self._hsim = tf.load_op_library(hsim_path)

    @property
    def hsim(self):
        return self._hsim
