# this file is for us to understand the legacy_qnpz params


# this are the compiler keys - which are essential for the HW
WEIGHTS_KEYS = [
    "kernel",
    "bias",
    "bias_q",
    "zero_point_in",
    "elementwise_addition/input_factor",
    "elementwise_addition/feed_repeat",
    "elementwise_addition/zp_elwa_acc",
    "bias_feed_repeat",  # we need- to compute the bias
    "bias_factor",  # we need to compute the bias
    "output_stage/mult_shift",  # why it is in output_Stage?????????
    "zp_kernel",
    "precision_split_zp",
]

APU_KEYS = [
    "output_stage/piecewise/x_points",
    "output_stage/piecewise/offsets",
    "output_stage/piecewise/slopes_m",
    "output_stage/piecewise/slopes_e",
]

WHY_COMPILER = [
    "qp_in",  # why is this needed?????????
    "qp_out",  # why is this needed?????????
    "limvals_in",  # why is this needed?????????
    "limvals_out",  # why is this needed?????????
    "output_stage/piecewise/slopes",  # why is this needed?????????
]

COMPILER_KEYS = WEIGHTS_KEYS + APU_KEYS + WHY_COMPILER

#############  debug info
KERNEL_BIAS_INFO = [
    "residue_0",
    "residue_1",
    "residue_2",
    "residue_3",
    "residue",
    "accumulator_scale_0",
    "accumulator_scale_1",
    "accumulator_scale_2",
    "accumulator_scale_3",
    "qp_kernel_0",
    "qp_kernel_1",
    "qp_kernel_2",
    "qp_kernel_3",
    "scale_kernel",
    "native_bias",
    "scale_bias",
    "weight_bits",
    "output_stage/output_factor",
    "limvals_kernel_0",
    "limvals_kernel_1",
    "limvals_kernel_2",
    "limvals_kernel_3",
    "limvals_kernel",
    "accumulator_offset",
    "elementwise_addition/qp_elwa",
    "elementwise_addition/limvals_elwa",
    "output_offset_elwa",
]

INER_LAYER_INFO = [
    "input_activation_bits",
    "output_activation_bits",
    "output_stage/beta",
    "output_activation_bitsoutput_stage/output_activation_bits",
    "output_stage/piecewise/apu_mode",
    "output_stage/piecewise/accumulator_size",
    "output_stage/piecewise/x_points_mask_max_value",
    "output_stage/piecewise/size_splits",  # not yet
    "output_stage/piecewise/ebias",
    "output_stage/piecewise/shifter_bias_max_value",
]
LIMVALS_PRE_INFO = [
    "limvals_in_pre_scale_matching",
    "limvals_output_pre_scale_matching",
    "elementwise_addition/limvals_elwa_pre_scale_matching",
    "limvals_pre_act",
]

DEBUG_INFO = INER_LAYER_INFO + KERNEL_BIAS_INFO + LIMVALS_PRE_INFO

KEYS_TO_CHECK = COMPILER_KEYS + DEBUG_INFO
# this we will be able to return only after implementing the quantization
KEYS_TO_CALC = ["output_stage/shift_delta", "negative_slopes_correction_factor"]

DEPRECATED = [
    "output_stage/zp_apu_compensation",  # deprecated
    "elementwise_addition/zp_elwa_apu",  # deprecated
    "x_points_non_scaled_0",
    "y_points_non_scaled_0",
    "slopes_non_scaled_0",
    "offsets_non_scaled_0",
]


# for deprecation-
DEFAULT_VAL_SCALE = 0.0
DEFAULT_VAL_ZP = -100392

QPS = ["qp_in", "qp_out", "elementwise_addition/qp_elwa", "qp_kernel_0", "qp_kernel_1", "qp_kernel_2", "qp_kernel_3"]
