def qp_to_limvals(qp, bits, is_symertric=False):
    # from qp into limvals
    zp_int = qp[0]
    scale = qp[1]
    if is_symertric:
        qmax = 2**bits - 2
        limvals_1 = (scale * qmax) / 2
        limvals_0 = -limvals_1
    else:
        qmax = (2**bits) - 1
        limvals_0 = scale * (0 - zp_int)
        limvals_1 = scale * (qmax - zp_int)
    return [limvals_0, limvals_1]
