from abc import ABC

from hailo_model_optimization.saitama.framework.common.saitama_module import SaitamaModule


class APUBase(SaitamaModule, ABC):
    pass
    # There's a main usage for the APU unit, which is the activation function
    # Not sure if we even need the base class for this case.

    # Regarding activation performance, we can consider the following:
    # 1. When using homogeneous activation functions, it might be best to use (native activation + rescale)
    # 2. When using piecewise linear non-homogeneous activation functions (such as Hard-Sigmoid), it might be best to use (rescale + native activation + rescale)
    # 3. otherwise use piecewise linear implementation, but check only the higher limit and incrmement all indexes by 1 each time
    #   (Fewer comparisons)
