from hailo_model_optimization.acceleras.utils.logger import default_logger
from hailo_model_optimization.saitama.framework.common.saitama_definitions import SaitmaBuilding
from hailo_model_optimization.saitama.translators.hailo_translator.base_hailo_translator import LayerMode
from hailo_model_optimization.saitama.translators.model_fuser.matching_structures import FUSER_REGISTRY


class ModelFuser:
    def __init__(self):
        self.logger = default_logger()

    def fuse(self, saitama_info: SaitmaBuilding, layer_mode: LayerMode) -> SaitmaBuilding:
        for name, fuser_algo in FUSER_REGISTRY.items():
            self.logger.info(f"Applying Saitama fuser algorithm: {name}")
            saitama_info = fuser_algo().fuse(saitama_info, layer_mode)

        return saitama_info
