#!/usr/bin/env python
# flake8: noqa
# TODO remove this supression by updating protobuf https://hailotech.atlassian.net/browse/SDK-60844
import warnings

warnings.filterwarnings("ignore", category=DeprecationWarning, module="hailo_sdk_client.allocator")

try:
    import cpuinfo

    cpu_flags = cpuinfo.get_cpu_info()["flags"]
except Exception:
    cpu_flags = None
    print("Warning! Unable to query CPU for the list of supported features.")

if cpu_flags is not None and "avx" not in cpu_flags:
    print(
        """
        This CPU does not support `avx` instructions, and they are needed to run Tensorflow.
        It is recommended to run the Dataflow Compiler on another host.
        Another option is to compile Tensorflow from sources without `avx` instructions.
    """
    )

import os
import pathlib
import subprocess

import hailo_model_optimization  # noqa: F401
from hailo_sdk_client.exposed_definitions import CalibrationDataType, JoinAction, NNFramework, States, InferenceContext
from hailo_sdk_client.runner.client_runner import ClientRunner
from hailo_sdk_client.tools.network_join import JoinAction
from hailo_sdk_common.export.hailo_graph_export import HailoGraphExport
from hailo_sdk_common.hailo_nn.hailo_nn import HailoNN
from hailo_sdk_common.logger.logger import default_logger
from hailo_sdk_common.model_params.model_params import ModelParams
from hailo_sdk_common.paths_manager.paths import SDKPaths
from hailo_sdk_common.paths_manager.version import get_version
from hailo_sdk_common.targets.inference_targets import (
    ParamsKinds,
    SdkFPOptimized,
    SdkFineTune,
    SdkMixed,
    SdkNative,
    SdkNumeric,
    SdkPartialNumeric,
)

logger = default_logger()

try:
    # importing should work anyway, but setting the layout will fail if graphviz is unavailable
    import pygraphviz

    G = pygraphviz.AGraph()
    G.layout("dot")
except (ValueError, OSError):
    default_logger().warning("Cannot use graphviz, so no visualizations will be created")
    SDKPaths().has_graphviz = False

SDKPaths().sdk_client_dir = os.path.abspath(os.path.dirname(__file__))

__version__ = get_version("hailo_sdk_client")

__all__ = [
    "HailoNN",
    "ModelParams",
    "HailoGraphExport",
    "ParamsKinds",
    "SdkNative",
    "SdkNumeric",
    "SdkFineTune",
    "SdkMixed",
    "SdkPartialNumeric",
    "ClientRunner",
    "CalibrationDataType",
    "NNFramework",
    "JoinAction",
    "NMSMetaArchitectures",
    "States",
    "SdkFPOptimized",
    "InferenceContext",
]


def check_system_requirements():
    script_path = SDKPaths().join_sdk_client("scripts/check_system_requirements.sh")
    logger.info(
        f"First time Hailo Dataflow Compiler is being used. Checking system requirements... (this might take "
        f"a few seconds)"
    )
    subprocess.run(f"bash {script_path}", shell=True, check=True)


def run_system_requirements_check_on_first_run():
    """Will run check_system_requirements.sh script during the first import once per installation."""
    if "VIRTUAL_ENV" in os.environ:
        venv_path = os.environ["VIRTUAL_ENV"]
        was_called = pathlib.Path(venv_path) / "etc/hailo/check_system_requirements_was_called"

        is_first_time = not pathlib.Path(was_called).exists()
        if is_first_time:
            check_system_requirements()
            was_called.parent.mkdir(parents=True, exist_ok=True)
            was_called.touch()


run_system_requirements_check_on_first_run()
