#!/usr/bin/env python

from hailo_sdk_common.hailo_nn.tools_params import ToolsParams, convert_to_float


class ContextCompilationParams(ToolsParams):
    DEFAULT_PARAMS = {
        "fps": 0,
    }
    VALUE_CONVERTERS = {
        "fps": convert_to_float,
    }

    def __init__(self):
        super().__init__()

    def to_pb(self, pb, pb_wrapper):
        self.set_pb_field(pb.compilation_params, "fps")

    def from_pb(self, pb, pb_wrapper):
        compilation_params_pb = pb.compilation_params
        self.get_pb_field(compilation_params_pb, "fps")
