#!/usr/bin/env python

from hailo_sdk_client.allocator.resources_params import AutoDouble, convert_to_auto_double
from hailo_sdk_common.hailo_nn.tools_params import ToolsParams


class ContextResourcesParams(ToolsParams):
    DEFAULT_PARAMS = {
        "max_utilization": AutoDouble("automatic"),
        "max_control_utilization": AutoDouble("automatic"),
        "max_compute_utilization": AutoDouble("automatic"),
        "max_memory_utilization": AutoDouble("automatic"),
        "max_input_aligner_utilization": AutoDouble("automatic"),
        "max_apu_utilization": AutoDouble("automatic"),
    }
    VALUE_CONVERTERS = {
        "max_utilization": convert_to_auto_double,
        "max_control_utilization": convert_to_auto_double,
        "max_compute_utilization": convert_to_auto_double,
        "max_memory_utilization": convert_to_auto_double,
        "max_input_aligner_utilization": convert_to_auto_double,
        "max_apu_utilization": convert_to_auto_double,
    }

    def __init__(self):
        super().__init__()
        self.set_default_params()

    def to_pb(self, pb, pb_wrapper):
        self.set_auto_pb_field(pb, pb_wrapper, "max_utilization")
        self.set_auto_pb_field(pb, pb_wrapper, "max_control_utilization")
        self.set_auto_pb_field(pb, pb_wrapper, "max_compute_utilization")
        self.set_auto_pb_field(pb, pb_wrapper, "max_memory_utilization")
        self.set_auto_pb_field(pb, pb_wrapper, "max_input_aligner_utilization")
        self.set_auto_pb_field(pb, pb_wrapper, "max_apu_utilization")

    def from_pb(self, pb, pb_wrapper):
        self.get_auto_pb_field(pb, "max_utilization", AutoDouble)
        self.get_auto_pb_field(pb, "max_control_utilization", AutoDouble)
        self.get_auto_pb_field(pb, "max_compute_utilization", AutoDouble)
        self.get_auto_pb_field(pb, "max_memory_utilization", AutoDouble)
        self.get_auto_pb_field(pb, "max_input_aligner_utilization", AutoDouble)
        self.get_auto_pb_field(pb, "max_apu_utilization", AutoDouble)
