#!/usr/bin/env python

from enum import Enum

from hailo_sdk_common.hailo_nn.tools_params import (
    ToolsParams,
    allowed_str_for_bool,
    allowed_str_for_enumerate,
    convert_str_to_bool,
    convert_str_to_enumerate,
    convert_to_int,
)


class LoggerVerbosity(Enum):
    TRACE = "trace"
    DEBUG = "debug"
    INFO = "info"
    WARNING = "warning"
    ERROR = "error"
    CRITICAL = "critical"
    OFF = "off"


class LoggerParams(ToolsParams):
    DEFAULT_PARAMS = {
        "console_verbosity": LoggerVerbosity.INFO,
        "file_verbosity": LoggerVerbosity.DEBUG,
        "logger_verbosity": LoggerVerbosity.DEBUG,
        "filename": "allocator.log",
        "file_size": 50 * 1024 * 1024,
        "enable_backtrace": True,
        "backtrace_ring_size": 500,
    }
    ALLOWED_VALUES = {
        "console_verbosity": allowed_str_for_enumerate(LoggerVerbosity),
        "file_verbosity": allowed_str_for_enumerate(LoggerVerbosity),
        "logger_verbosity": allowed_str_for_enumerate(LoggerVerbosity),
        "enable_backtrace": allowed_str_for_bool(),
    }
    VALUE_CONVERTERS = {
        "console_verbosity": convert_str_to_enumerate(LoggerVerbosity),
        "file_verbosity": convert_str_to_enumerate(LoggerVerbosity),
        "logger_verbosity": convert_str_to_enumerate(LoggerVerbosity),
        "file_size": convert_to_int,
        "enable_backtrace": convert_str_to_bool,
        "backtrace_ring_size": convert_to_int,
    }

    def __init__(self):
        super().__init__()
        self.set_default_params()

    def to_pb(self, pb, pb_wrapper):
        self.set_pb_field(pb, "console_verbosity", pb_wrapper.LOGGER_VERBOSITY_TYPE_TO_PB)
        self.set_pb_field(pb, "file_verbosity", pb_wrapper.LOGGER_VERBOSITY_TYPE_TO_PB)
        self.set_pb_field(pb, "logger_verbosity", pb_wrapper.LOGGER_VERBOSITY_TYPE_TO_PB)
        self.set_pb_field(pb, "filename")
        self.set_pb_field(pb, "file_size")
        self.set_pb_field(pb, "enable_backtrace")
        self.set_pb_field(pb, "backtrace_ring_size")
