#!/usr/bin/env python

from abc import ABCMeta, abstractmethod
from collections import namedtuple

from future.utils import with_metaclass

OptionalModelParams = namedtuple(
    "OptionalModelParams",
    [
        "translate_input",
        "model_name",
        "custom_graph",
        "custom_session",
        "custom_inputs",
        "consts",
        "translated_consts",
        "activation_callback",
        "native_layers",
        "fine_tune_params",
        "mixed_params",
        "is_mercury_arch",
        "is_pluto_arch",
        "force_weightless_model",
        "run_numeric_in_int32",
        "activation_points",
        "twin_mode",
        "enable_clipping",
    ],
)
OptionalModelParams.__new__.__defaults__ = (
    None,
    False,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    None,
    False,
    False,
    False,
    False,
    None,
    False,
    False,
)


class Model(with_metaclass(ABCMeta, object)):
    """
    Defines Interface for all golden model framework executers.
    """

    @abstractmethod
    def export_description(self):
        pass

    @abstractmethod
    def export_params(self):
        pass

    @abstractmethod
    def load_params(self, params):
        pass

    @abstractmethod
    # TODO: remove this method after multiple inputs integration
    def get_input_layer(self):
        pass

    @abstractmethod
    def get_input_layers(self):
        pass

    @abstractmethod
    def get_output_layers(self, activated=False):
        pass
