#!/usr/bin/env python


def draw_graphs(file_path, graphvizs):
    names = ["{}.{}".format(file_path, "svg")]
    if len(graphvizs) > 1:
        names = ["{}.{}.{}".format(file_path, i, "svg") for i in range(len(graphvizs))]

    for i, graph in enumerate(graphvizs):
        graph.layout("dot")
        graph.draw(f"{names[i]}", prog="dot")

    return names
