#!/usr/bin/env python

from hailo_sdk_client.sdk_backend.sdk_backend_exceptions import BackendModelException, BackendModelParsingException


class RecordableParserError(BackendModelException):
    pass


class FatalParserError(BackendModelException):
    pass


class UnsupportedModelError(FatalParserError):
    pass


class CantFindGraphStartError(UnsupportedModelError):
    pass


class CantFindGraphEndError(UnsupportedModelError):
    pass


class MisspellNodeError(UnsupportedModelError):
    pass


class UnexpectedNodeError(RecordableParserError):
    pass


class UnsupportedQuantizedWeightsError(UnsupportedModelError):
    pass


class UnsupportedAddLayerError(FatalParserError):
    pass


class UnsupportedWeightsError(FatalParserError):
    pass


class UnsupportedInputShapesError(FatalParserError):
    def __init__(self, message, recommendation=None):
        self._message = message
        self._recommendation = recommendation

    @property
    def recommendation(self):
        return self._recommendation

    @recommendation.setter
    def recommendation(self, recommendation):
        self._recommendation = recommendation

    @property
    def message(self):
        return self._message

    @message.setter
    def message(self, message):
        self._message = message


class UnsupportedInputFormatError(UnsupportedInputShapesError):
    pass


class UnsupportedActivationLayerError(RecordableParserError):
    pass


class UnsupportedRNNLayerError(RecordableParserError):
    pass


class UnsupportedLSTMLayerError(RecordableParserError):
    pass


class UnsupportedGRULayerError(RecordableParserError):
    pass


class UnsupportedFormatConversionLayerError(RecordableParserError):
    pass


class UnsupportedReduceMaxLayerError(RecordableParserError):
    pass


class UnsupportedReduceMinLayerError(RecordableParserError):
    pass


class UnsupportedReduceMeanLayerError(RecordableParserError):
    pass


class UnsupportedShuffleLayerError(RecordableParserError):
    pass


class UnsupportedReduceL2LayerError(RecordableParserError):
    pass


class UnsupportedReduceSumSquareLayerError(RecordableParserError):
    pass


class UnsupportedReduceSumLayerError(RecordableParserError):
    pass


class UnsupportedSpaceToDepthLayerError(RecordableParserError):
    pass


class UnsupportedNormalizationLayerError(RecordableParserError):
    pass


class UnsupportedLayerNormLayerError(RecordableParserError):
    pass


class UnsupportedL2NormLayerError(RecordableParserError):
    pass


class UnsupportedSquareLayerError(RecordableParserError):
    pass


class UnsupportedFeatureSplitterLayerError(RecordableParserError):
    pass


class UnsupportedSliceLayerError(RecordableParserError):
    pass


class UnsupportedEWLayerError(RecordableParserError):
    pass


class UnsupportedLogitsLayerError(RecordableParserError):
    pass


class UnsupportedDepthToSpaceLayerError(RecordableParserError):
    pass


class UnsupportedResizeLayerError(RecordableParserError):
    pass


class UnsupportedPaddingError(RecordableParserError):
    pass


class UnsupportedMultLayerError(RecordableParserError):
    pass


class UnsupportedReshapeError(RecordableParserError):
    pass


class UnsupportedConvLayerError(RecordableParserError):
    pass


class UnsupportedPoolingLayerError(RecordableParserError):
    pass


class UnsupportedFeatureSplitterError(RecordableParserError):
    pass


class UnsupportedDilationError(RecordableParserError):
    pass


class UnsupportedStridesError(RecordableParserError):
    pass


class UnsupportedGlobalAvgpoolLayerError(RecordableParserError):
    pass


class UnsupportedEinsumLayerError(RecordableParserError):
    pass


class UnsupportedConcatLayerError(RecordableParserError):
    pass


class UnsupportedZeroDimensionShapeError(RecordableParserError):
    pass


class UnsupportedOperationError(RecordableParserError):
    pass


class UnsupportedPostprocessLayerError(RecordableParserError):
    pass


class UnsupportedSoftmaxLayerError(RecordableParserError):
    pass


class UnsupportedLogSoftmaxLayerError(RecordableParserError):
    pass


class UnsupportedConv3DError(RecordableParserError):
    pass


class UnsupportedConstInputError(RecordableParserError):
    pass


class UnsupportedEqualLayerError(RecordableParserError):
    pass


class UnsupportedGatherLayerError(RecordableParserError):
    pass


class UnsupportedTileLayerError(RecordableParserError):
    pass


class UnsupportedScatterNDError(RecordableParserError):
    pass


class CantFindSwishBetaError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find const swish beta node",
        )


class CantFindBiasedDelatError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find const biased delta node",
        )


class BatchNormParsingError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(f"Can't parse batch normalization near node {vertex_name}")


class CantFindLeakyAlphaError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find Leaky Relu alpha node",
        )


class CantFindPReluSlopeError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find PRelu alpha slope node",
        )


class CantFindThresholdError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find const threshold node",
        )


class CantFindSigmoidParametersError(RecordableParserError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected node {vertex_name} - cannot find const parameters node",
        )


class ParsingWithRecommendationException(BackendModelParsingException):
    def __init__(
        self,
        message,
        client_message=None,
        recommended_start_node_names=None,
        recommended_end_node_names=None,
        parsing_report=None,
    ):
        super().__init__(message, client_message)
        self._recommended_start_node_names = recommended_start_node_names
        self._recommended_end_node_names = recommended_end_node_names
        self._parsing_report = parsing_report

    @property
    def recommended_start_node_names(self):
        return self._recommended_start_node_names

    @property
    def recommended_end_node_names(self):
        return self._recommended_end_node_names

    @property
    def parsing_report(self):
        return self._parsing_report

    def __str__(self):
        errors_str = self.client_message
        if self.recommended_start_node_names:
            errors_str += f'\nPlease try to parse the model again, using these start node names: {", ".join(self.recommended_start_node_names)}'
        if self.recommended_end_node_names:
            errors_str += f'\nPlease try to parse the model again, using these end node names: {", ".join(self.recommended_end_node_names)}'
        return errors_str
