#!/usr/bin/env python
from hailo_sdk_client.model_translator.exceptions import UnsupportedModelError


class SpecificExampleONNXError(UnsupportedModelError):
    def __init__(self, vertex_name):
        super().__init__(
            f"Unexpected ONNX node {vertex_name} - cannot parse example node",
        )


class NoParamsModelError(Exception):
    pass
