from __future__ import annotations

from dataclasses import dataclass
from typing import TYPE_CHECKING

if TYPE_CHECKING:
    import numpy as np

    from hailo_sdk_common.hailo_nn.hn_definitions import PaddingType
import numpy as np

from hailo_sdk_common.hailo_nn.hn_definitions import PaddingType, TemporaryPaddingType


@dataclass
class Conv3DInfo:
    kernel: np.ndarray
    bias: np.ndarray | None
    padding: TemporaryPaddingType | PaddingType
    pads_val: list[int]
    strides: list[int]
    dilations: list[int]
    output_shapes: list[list[int]]
    input_disparity: int
    groups: int


@dataclass
class Conv2DInfo:
    kernel: np.ndarray
    bias: np.ndarray | None
    padding: TemporaryPaddingType | PaddingType
    pads_val: list[int]
    strides: list[int]
    dilations: list[int]
    output_shapes: list[list[int]]
    groups: int
