from typing import Dict, List, Optional

from pydantic.v1 import BaseModel, Field

from hailo_sdk_client.exposed_definitions import Dims
from hailo_sdk_common.hailo_nn.hn_definitions import BlockType, NMSMetaArchitectures


class NetParamsReport(BaseModel):
    start_node_names: Optional[List[str]]
    end_node_names: Optional[List[str]]
    detected_post_process: Optional[NMSMetaArchitectures]

    class Config:
        use_enum_values = True


class ParsingReport(BaseModel):
    name: str
    net_params: NetParamsReport
    layers: Dict[str, dict]
    blocks: Dict[BlockType, Dict[str, Dict[str, List[str]]]] = Field({})
    output_format: Dict[str, List[Dims]] = Field({})

    class Config:
        use_enum_values = True
