#!/usr/bin/env python


from hailo_sdk_client.model_translator.exceptions import UnsupportedModelError
from hailo_sdk_client.sdk_backend.sdk_backend_exceptions import BackendNotImplementedError


class BaseMode:
    def set(self, mode):
        raise BackendNotImplementedError("Function not implemented on SDK backend")

    @property
    def _current(self):
        raise BackendNotImplementedError("Function not implemented on SDK backend")

    def __str__(self):
        return str(self._current)

    def __repr__(self):
        return f"{self.__class__.__name__}({self!s})"

    def __eq__(self, other):
        return str(self) == str(other)

    # TODO: Required for Python2 BW compatibility (SDK-10038)
    # This impl' comes by default in Python3
    def __ne__(self, other):
        return not (self == other)


class SimpleMode(BaseMode):
    def __init__(self, mode=None):
        super().__init__()
        self._mode = mode

    def set(self, mode):
        self._mode = mode

    @property
    def _current(self):
        return self._mode


class ConstrainedMode(BaseMode):
    def __init__(self):
        super().__init__()
        self._performed = []

    def _is_possible(self, action):
        raise BackendNotImplementedError

    def set(self, action):
        if not self._is_possible(action):
            raise UnsupportedModelError(
                f"Can't perform action {action} after actions {self._performed!s}",
            )
        self._performed.append(action)

    def try_set(self, action):
        return self._is_possible(action)

    @property
    def _current(self):
        return self._performed[-1]
