#!/usr/bin/env python
from hailo_sdk_client.model_translator.exceptions import UnsupportedModelError
from hailo_sdk_client.model_translator.state_machine import ConstrainedMode, SimpleMode


class TFSimpleSubMode(SimpleMode):
    pass


class TFMode(SimpleMode):
    INPUT = "input"
    CONV = "conv"
    DENSE = "dense"
    BN = "bn"
    ACTIVATION = "activation"
    SHUFFLE = "shuffle"
    DEPTH_TO_SPACE = "depth_to_space"
    BIAS_ADD = "bias_add"
    RESIZE = "resize"
    EW_MULT = "ew_mult"
    NORMALIZATION = "normalization"
    OUTSIDE = "outside"
    GROUP_CONV_SPLIT = "group_conv_split"
    SPACE_TO_DEPTH = "space_to_depth"
    EW_DIV = "ew_div"
    EW_SUB = "ew_sub"
    REDUCE_L2 = "reduce_l2"
    L2_NORMALIZATION = "l2_normalization"


class TFSubMode(ConstrainedMode):
    OP = "op"
    OP_AFTER = "op_after"
    INIT_BIAS_ADD = "init_bias_add"
    SPACE_TO_BATCH = "space_to_batch"
    BATCH_TO_SPACE = "batch_to_space"
    POSSIBLE_INITIAL_CHAINS = [[INIT_BIAS_ADD], [SPACE_TO_BATCH]]
    POSSIBLE_POST_OPS = [BATCH_TO_SPACE]

    def __init__(self, is_conv=True, is_bias=False, is_dilation_s2b=False):
        super().__init__()
        self._performed = [type(self).OP]
        if is_dilation_s2b:
            if not is_conv:
                raise UnsupportedModelError("Can't parse dilated S2B layer for non-conv layer")
            elif is_bias:
                raise UnsupportedModelError("Can't parse dilated S2B layer with external bias")
        if is_bias:
            self._performed = [type(self).INIT_BIAS_ADD]
        elif is_dilation_s2b:
            self._performed = [type(self).SPACE_TO_BATCH]

    def _is_possible(self, action):
        if action in self._performed:
            return False
        if action == type(self).OP:
            return False
        elif action == type(self).OP_AFTER:
            # in this case:
            # 1. self._performed contains a sequence of performed ops
            # 2. The ops must be one of the possible initial chains
            if self._performed not in type(self).POSSIBLE_INITIAL_CHAINS:
                return False
        elif (
            action == type(self).INIT_BIAS_ADD or action in type(self).POSSIBLE_POST_OPS and not self._did_perform_op()
        ):
            return False
        return True

    def _did_perform_op(self):
        return type(self).OP in self._performed or type(self).OP_AFTER in self._performed


class TFGroupConvSubMode(TFSubMode):
    pass


class TFMultiStepSubMode(ConstrainedMode):
    ENTRANCE = "entrance"
    INSIDE = "inside"

    def __init__(self):
        super().__init__()
        self._performed = [type(self).ENTRANCE]

    def _is_possible(self, action):
        if action == type(self).ENTRANCE:
            return False
        return True


class TFBatchNormSubMode(TFMultiStepSubMode):
    pass


class TFShuffleSubMode(TFMultiStepSubMode):
    pass


class TFDepthToSpaceSubMode(TFMultiStepSubMode):
    pass


class TFActivationSubMode(TFMultiStepSubMode):
    pass


class TFSpaceToDepthSubMode(TFMultiStepSubMode):
    pass


class TFResizeNearestSubMode(TFMultiStepSubMode):
    pass


class TFReduceL2SubMode(TFMultiStepSubMode):
    pass


class TFRL2NormalizationSubMode(TFMultiStepSubMode):
    pass
