#!/usr/bin/env python
from hailo_sdk_client.sdk_backend.sdk_backend_exceptions import BackendTypeError
from hailo_sdk_common.model_params.model_params import ModelParams
from hailo_sdk_common.targets.inference_targets import ParamsKinds


def set_quantized_params(preprocessed_params, quantization_statistics):
    """
    This function updates params with calibration results.

    Args:
        preprocessed_params: params that need to be updated.
        quantization_statistics: calibration results to use for this update.

    Returns:
        out_params: the updated quantization params

    """
    # If none of the layers have native params, this case can occur
    if not preprocessed_params:
        preprocessed_params = ModelParams({})

    if not isinstance(preprocessed_params, ModelParams):
        raise BackendTypeError("preprocessed params must be of type ModelParams")

    params = preprocessed_params + quantization_statistics
    out_params = params[:]
    for layer in out_params:
        if hasattr(out_params[layer], "bias_q"):
            out_params.set_layer_bias(layer, params.bias_q[layer])

    out_params.set_params_kind(ParamsKinds.TRANSLATED)
    return out_params
