#!/usr/bin/env python

import os

from hailo_sdk_client.paths_manager.sdk_runner_paths import RunnerWithDirs
from hailo_sdk_common.paths_manager.paths import SDKPaths


class BuildDirCreator(RunnerWithDirs):
    """
    @purpose: creates the build dir for the SDK's itself and its users
    """

    def __init__(self, hw_arch):
        super().__init__(hw_arch)
        self._paths = SDKPaths()

    def _create_build_dirs(self):
        type(self)._create_dirs([self._config_dirs.get_dir(d) for d in self._config_dirs.build_dirs_keys])

    def prepare_build_dir(self):
        self._create_build_dirs()

    @staticmethod
    def _create_dirs(dirs):
        for current_dir in dirs:
            if os.path.exists(current_dir):
                continue
            try:
                os.makedirs(current_dir)
            except NotADirectoryError:
                raise NotADirectoryError(
                    "Build dir is somehow a file and not a directory. Please remove it by running "
                    f'"rm {SDKPaths().build_dir}" and try again.',
                )
