#!/usr/bin/env python


def get_platform():
    """
    Safely import hailo platform.

    :return: hailo_platform if installed, None otherwise.
    """
    try:
        import hailo_platform

        return hailo_platform

    except ImportError:
        pass


def get_base_commands():
    """
    Safely imports BaseCommands.

    :return: PlatformCommands if hailo_platform installed, BaseCommands otherwise.
    """
    try:
        from hailo_platform.tools.hailocli.main import PlatformCommands

        return PlatformCommands

    except ImportError:
        from hailo_sdk_client.tools.cmd_utils.base_utils import BaseCommands

        return BaseCommands
