from hailo_sdk_common.hailo_nn.hn_definitions import LayerType


def get_def_loss_layers(hn_model, mindepth=0, maxdepth=3):
    """
    BFS for convs from final down to given depth to configure the loss layers to finetune
    Args:
        hn_model: :class:`~hailo_sdk_common.hailo_nn.hailo_nn.HailoNN` model object
        midepth: from which model slice to start the search, counting from the network end
        maxepth: down to which model slice to end the search
    Returns:
        def_loss_layers (list): List of layer names to calculate the distillation loss over
    """
    current_slice = list(hn_model.get_real_output_layers())
    losslayers = []
    depth = 0
    while depth <= maxdepth or len(losslayers) == 0:
        # print("current_slice", current_slice)
        if depth >= mindepth:
            losslayers += [ll for ll in current_slice if ll.op in {LayerType.dense, LayerType.conv}]
        next_slice = []
        for layer in current_slice:
            predecessors = hn_model.predecessors(layer)
            next_slice += predecessors
        current_slice = next_slice
        depth += 1
    return [ll.name for ll in losslayers]
