class ClientRunnerException(Exception):
    """Raised when an API call returns after an exception occurred in the client side."""


class UnsupportedTargetException(ClientRunnerException):
    """Raised when trying to run the SDK with unsupported inference target."""


class UnsupportedCustomSessionException(ClientRunnerException):
    """Raised when a custom session is given but a preprocessing graph is None."""


class InvalidParserInputException(ClientRunnerException):
    """Raised when trying to parse an invalid model (e.g. end_node_name isn't part of the graph)."""


class InvalidArgumentsException(ClientRunnerException):
    """Raised when a method input arguments are invalid."""


class HNNotSetException(ClientRunnerException):
    """Raised when trying to attempt the hn before it was set."""


class UnsupportedRunnerJoinException(ClientRunnerException):
    """Raised when illegal join call is made."""


class HailoPlatformMissingException(ClientRunnerException):
    """Hailo platform package not exist when it's required"""


class UnsupporteLoraAdapterException(ClientRunnerException):
    """Raised when the lora adapter info is not supported or not matched in the HN"""
