import os
import pathlib

from hailo_sdk_client.sdk_backend.script_parser.model_script_parser import ModelScriptParser
from hailo_sdk_common.hailo_nn.hailo_nn import HailoNN

local_model_script_parser = ModelScriptParser(hn=HailoNN())


def is_string_model_script_or_path(string: str, hn=None) -> bool:
    model_script_err = None
    file_path_err = None
    if hn is not None:
        local_model_script_parser.update_model(hn)

    try:
        local_model_script_parser.parse_script(string)
    except Exception as err:
        model_script_err = f"Model script parsing failed: {err}."

    if (not isinstance(string, pathlib.Path) and not isinstance(string, str)) or not os.path.isfile(string):
        file_path_err = f"Model script file not found in location: {string}."

    if model_script_err and file_path_err:
        return False, (model_script_err or "") + " " + (file_path_err or "")

    return True, None
