import time

import hailo_sdk_client
from hailo_sdk_client.sdk_backend.profiler.metadata_extractor import MetadataExtractor
from hailo_sdk_client.sdk_backend.profiler.optimization_data_extractor import OptimizationDataExtractor


class Profiler:
    FIELD_NOT_AVAILABLE = "N/A"

    def __init__(
        self,
        profiling_mode,
        hw_arch,
        hn,
        params,
        translated_params,
        hailo_optimized_params,
        statistics_params,
        modifications_meta_data,
        optimization_commands,
        mo_flavor,
        flavor_config,
    ):
        self._translated_params = translated_params
        self._profiling_mode = profiling_mode
        self._metadata_extractor = MetadataExtractor(
            hn=hn,
            modifications_meta_data=modifications_meta_data,
            hw_arch=hw_arch,
        )
        if self._translated_params:
            self._optimization_data_extractor = OptimizationDataExtractor(
                hn=hn,
                params=params,
                translated_params=translated_params,
                hailo_optimized_params=hailo_optimized_params,
                statistics_params=statistics_params,
                mo_flavor=mo_flavor,
                flavor_config=flavor_config,
                optimization_commands=optimization_commands,
            )
        else:
            self._optimization_data_extractor = None

    def get_export(self):
        export = {
            "stats": {
                "profiler_parameters": {
                    "time": time.strftime("%a, %d %b %Y %H:%M:%S %z", time.localtime()),
                    "compiler_version": hailo_sdk_client.__version__,
                    "profiling_mode": self._profiling_mode,
                    "is_quantized": self._translated_params is not None,
                },
                "model_details": {},
                "performance_details": [],
            },
            "csv_data": [],
            "latency_data": {
                "runtime_data": {},
            },
            "accuracy_data": {},
            "hn_model": {},
        }

        self._metadata_extractor.update(export)
        if self._optimization_data_extractor:
            self._optimization_data_extractor.update(export)

        return export
