from abc import ABC

from hailo_model_optimization.acceleras.utils.acceleras_definitions import LAYERS_KEY, MOConfigCommand
from hailo_sdk_client.sdk_backend.script_parser.commands import SupportedCommands
from hailo_sdk_client.sdk_backend.script_parser.model_optimization_commands import FeatureOptimizationCommand


class ModelOptimizationConfigCommand(FeatureOptimizationCommand, ABC):
    def __init__(self, feature, cmd_str, cmd_line, kwargs):
        super().__init__(SupportedCommands.MODEL_OPTIMIZATION_CONFIG, feature, cmd_str, cmd_line, kwargs)

    @classmethod
    def from_tokens(cls, tokens, cmd_str, cmd_line):
        feature_value, kwargs = cls._build_kwargs(tokens.function_args)
        feature = MOConfigCommand(feature_value)
        sub_commands_classes = {
            MOConfigCommand.compression_params: CompressionSubCommand,
            MOConfigCommand.global_config: GlobalsSubCommand,
            MOConfigCommand.precision_config: PrecisionConfigSubCommand,
            MOConfigCommand.calibration: CalibrationSubCommand,
            MOConfigCommand.checker_cfg: CheckerSubCommand,
            MOConfigCommand.negative_exponent: NegExpSubCommand,
        }
        return sub_commands_classes[feature](cmd_str, cmd_line, kwargs)

    def export(self):
        return self._export_global_config()

    def add_scope(self, scope_name, force=False):
        """This command has no layers"""


class GlobalsSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.global_config, cmd_str, cmd_line, kwargs)


class CompressionSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.compression_params, cmd_str, cmd_line, kwargs)


class CalibrationSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.calibration, cmd_str, cmd_line, kwargs)


class CheckerSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.checker_cfg, cmd_str, cmd_line, kwargs)


class PrecisionConfigSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.precision_config, cmd_str, cmd_line, kwargs)


class NegExpSubCommand(ModelOptimizationConfigCommand):
    def __init__(self, cmd_str, cmd_line, kwargs):
        super().__init__(MOConfigCommand.negative_exponent, cmd_str, cmd_line, kwargs)

    @classmethod
    def from_kwargs(cls, kwargs, cmd_str, cmd_line):
        return cls(cmd_str, cmd_line, kwargs)

    def expand_glob(self, layers_scope_from_hn, net_scopes):
        layers_from_script = self.function_args.get(LAYERS_KEY)
        if layers_from_script is not None:
            expanded_glob = self._expand_glob_for_key(layers_from_script, layers_scope_from_hn, net_scopes)
            self.function_args[LAYERS_KEY] = expanded_glob

    def export(self):
        return self._export_per_layer_config(new_format=True) if self.has_layers() else self._export_global_config()

    def add_scope(self, scope_names, force=False):
        self._add_scope_to_key(scope_names, LAYERS_KEY, force=force)
