"""
Makes sure the autocompletion is installed in virtualenv so calling "hailo ..." from CLI will have
tab completion. The auto-completion will be functional only after the 1st import.
If Hailo-Dataflow-Compiler is installed outside a virtualenv, the autocompletion won't be installed.

Auto completion supported shells:
    - Bash
"""

import contextlib
import shutil
from pathlib import Path


def _in_venv():
    return "site-packages" in Path(__path__[0]).parts


if _in_venv():
    VenvBaseDir = Path("/", *__path__[0].split("/")[: __path__[0].split("/").index("lib")])
    VenvAutoCompletionDir = VenvBaseDir / "bin/hailo_autocompletion"
    AutoCompletionDir = Path(__path__[0]) / "autocompletion"
    BashAutoCompletion = VenvAutoCompletionDir / "hailo_completion.bash"
    VenvActivationScript = VenvBaseDir / "bin/activate"

    # check if the autocompletion dir was already created - if so, no need to do it again
    if not VenvAutoCompletionDir.exists():
        # add the autocompletion scripts to the virtualenv for later use
        with contextlib.suppress(FileExistsError):
            shutil.copytree(
                str(AutoCompletionDir),
                str(VenvAutoCompletionDir),
                ignore=shutil.ignore_patterns("__*"),
            )

        # add a hook inside virtualenv/bin/activate that will install the auto-completion
        with open(VenvActivationScript, "a") as f:
            f.write(
                "\n".join(
                    (
                        "",
                        '# Adding "hailo" auto-comlpetion',
                        f"source {BashAutoCompletion}",
                    ),
                ),
            )
