import json
import os
import sys

from prompt_toolkit.completion import CompleteEvent
from prompt_toolkit.completion.filesystem import PathCompleter
from prompt_toolkit.document import Document


def get_subcommand_parser_info(argv, command_json):
    opts = {}
    commands = command_json
    while argv:
        while argv and argv[0] not in commands:
            argv.pop(0)
        if argv:
            opts, commands = commands[argv.pop(0)]
    return opts, commands


def get_completion(command_json, argv):
    opts, commands = get_subcommand_parser_info(list(argv), command_json)
    if argv and argv[-1].startswith("-"):
        o = argv[-1]
        if opts.get(o, None):
            return opts[o]
    elif len(argv) > 1 and argv[-2].startswith("-"):
        o = argv[-2]
        if o in opts and opts[o] and argv[-1] not in opts[o]:
            return [v for v in opts[o] if v.startswith(argv[-1])]
    opts = list(opts.keys())
    commands = list(commands.keys())
    if commands:
        return commands
    if os.path.isfile(argv[-1]):
        paths = []
    else:
        paths = [argv[-1] + i.text for i in PathCompleter().get_completions(Document(argv[-1]), CompleteEvent())]
        if not paths:
            paths = os.listdir(".")
    paths = [p + os.sep if os.path.isdir(p) else p for p in paths]
    return opts + paths


if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: autocomplete.py <command_json_path>")
    else:
        command_json = json.load(open(sys.argv[1]))
        completions = get_completion(command_json, sys.argv[2:])
        print(*completions)
