# Bash completion for hailo command
_hailo_completion()
{
    local autocomplete_script="$(dirname $BASH_SOURCE)/autocomplete.py"
    local autocomplete_json="$(dirname $BASH_SOURCE)/hailo_autocomplete.json"
    if [[ -f "$autocomplete_script" ]] && [[ -f "$autocomplete_json" ]]; then
        local cwords_until_cursor=(${COMP_LINE:0:$COMP_POINT})
        COMPREPLY=($(compgen -W "$(python $autocomplete_script $autocomplete_json ${cwords_until_cursor[@]})" -- "${cwords_until_cursor[$COMP_CWORD]}"))
        [[ $COMPREPLY == */ ]] && compopt -o nospace
    fi
}
complete -F _hailo_completion hailo
