from hailo_sdk_client.tools.cmd_utils.cmd_definitions import Commands


def get_command_class(command):
    if command == Commands.ANALYZE_NOISE:
        from hailo_sdk_client.tools.hailo_lat_cli import HailoQuantAnalyzerCLI

        return HailoQuantAnalyzerCLI
    elif command == Commands.COMPILER:
        from hailo_sdk_client.tools.compiler_cli import CompilerCLI

        return CompilerCLI
    elif command == Commands.PARAMS_CSV:
        from hailo_sdk_client.tools.convert_translated_params_to_csv import NpzCsvRunner

        return NpzCsvRunner
    elif command == Commands.PARSER:
        from hailo_sdk_client.tools.parser_cli import NetParser

        return NetParser
    elif command == Commands.PROFILER:
        from hailo_sdk_client.tools.profiler.profiler import Profiler

        return Profiler
    elif command == Commands.OPTIMIZE:
        from hailo_sdk_client.tools.optimize_cli import OptimizeCLI

        return OptimizeCLI
    elif command == Commands.VISUALIZER:
        from hailo_sdk_client.tools.visualize_hn import Visualizer

        return Visualizer
    elif command == Commands.TUTORIAL:
        from hailo_sdk_client.tools.tutorial_runner import TutorialRunner

        return TutorialRunner
    elif command == Commands.HAR:
        from hailo_sdk_client.tools.hailo_archive_cli import HailoArchiveCLI

        return HailoArchiveCLI
    elif command == Commands.JOIN:
        from hailo_sdk_client.tools.join_cli import JoinCLI

        return JoinCLI
    elif command == Commands.HAR_ONNX_RT:
        from hailo_sdk_client.tools.har_onnx_cli import HarONNXCLI

        return HarONNXCLI
    elif command == Commands.RUNTIME_PROFILER:
        from hailo_sdk_client.tools.hrt_profiler.runtime_profiler import RuntimeProfiler

        return RuntimeProfiler
    elif command == Commands.DFC_STUDIO:
        from hailo_sdk_client.tools.dfc_studio.dfc_studio import DfcStudio

        return DfcStudio
    else:
        from hailo_sdk_client.tools.cmd_utils.base_utils import CmdUtilsBaseUtilError

        raise CmdUtilsBaseUtilError(f"{command.value} not found")
