#!/usr/bin/env python
import json

from hailo_sdk_client.exposed_definitions import Dims
from hailo_sdk_client.tools.cmd_utils.base_utils import CmdUtilsBaseUtilError


def parse_dict_or_list_arg(arg_value, arg_name="tensor_shapes"):
    if not arg_value:
        return None

    if isinstance(arg_value, dict) and arg_name == "input_format":
        return {input_name: parse_arg_value(arg_value[input_name], arg_name="input_format") for input_name in arg_value}

    value_type = "<format>" if arg_name == "input_format" else "<shape>"
    values_list = []
    values_dict = {}
    for arg_str in arg_value:
        arg_split = arg_str.split("=")
        if len(arg_split) == 2:
            if values_list:
                raise CmdUtilsBaseUtilError(
                    f"Item {arg_str} in {arg_name} is in the form of <tensor_name>={value_type}, but "
                    f"found other items in the form of {value_type}",
                )
            values_dict[arg_split[0]] = parse_arg_value(arg_split[1], arg_name)
        elif len(arg_split) == 1:
            if values_dict:
                raise CmdUtilsBaseUtilError(
                    f"Item {arg_str} in {arg_name} is in the form of {value_type}, but found other items "
                    f"in the form of <tensor_name>={value_type}",
                )
            values_list.append(parse_arg_value(arg_str, arg_name))
        else:
            raise CmdUtilsBaseUtilError(
                f"Item {arg_str} is not in the form of <tensor_name>={value_type} or {value_type}",
            )
    if len(values_list) > 1:
        raise CmdUtilsBaseUtilError(
            f"Found more than one item in the form of {value_type} in {arg_name}. To provide "
            f"more than one value please use the form <tensor_name>={value_type}"
        )
    return values_list if values_list else values_dict


def parse_arg_value(value, arg_name="tensor_shapes"):
    if arg_name == "input_format":
        char_to_dim = {dim[0].upper(): dim for dim in Dims}
        char_to_dim["N"] = Dims.BATCH
        if any(x.upper() not in char_to_dim for x in value):
            raise CmdUtilsBaseUtilError(f"Can't parse {value} as {arg_name}, plase verify and try again.")
        res = [char_to_dim[x.upper()] for x in value]
    else:
        res = json.loads(value)
    return res
