"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const cors_1 = __importDefault(require("cors"));
const path_1 = __importDefault(require("path"));
const projects_route_1 = __importDefault(require("./routes/projects.route"));
const parsing_services_1 = __importDefault(require("./services/parsing.services"));
process.on('uncaughtException', function (err) {
    console.error(err);
});
const app = (0, express_1.default)();
(() => __awaiter(void 0, void 0, void 0, function* () {
    parsing_services_1.default.init();
}))();
app.use((0, cors_1.default)());
app.use(express_1.default.json({ limit: '250mb' }));
app.use(express_1.default.static(path_1.default.join(__dirname, 'public')));
app.use('/models', projects_route_1.default);
exports.default = app;
