"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LOG_FILE_NAME = exports.PROJECT_FILE_CONFIG = exports.BASIC_NODE_TYPES = exports.TFLITE_BACKEND_LAYER_TYPES = exports.TFLITE_FRONTEND_LAYER_TYPES = exports.ONNX_LAYER_TYPES = exports.HAILO_LAYER_TYPES = exports.MODEL_FILE_EXTENSIONS = exports.BACKEND_PARSER_MODEL_FORMATS = void 0;
exports.BACKEND_PARSER_MODEL_FORMATS = {
    ONNX: 'onnx',
    TF: 'tf',
};
exports.MODEL_FILE_EXTENSIONS = {
    ONNX: 'onnx',
    TFLITE: 'tflite',
};
var HAILO_LAYER_TYPES;
(function (HAILO_LAYER_TYPES) {
    HAILO_LAYER_TYPES["RESIZE"] = "resize";
    HAILO_LAYER_TYPES["FORMAT_CONVERSION"] = "format_conversion";
    HAILO_LAYER_TYPES["NORMALIZATION"] = "normalization";
    HAILO_LAYER_TYPES["BATCH_NORM"] = "batch_norm";
    HAILO_LAYER_TYPES["CONV"] = "conv";
    HAILO_LAYER_TYPES["DW"] = "dw";
    HAILO_LAYER_TYPES["DECONV"] = "deconv";
    HAILO_LAYER_TYPES["DENSE"] = "dense";
    HAILO_LAYER_TYPES["ELEMENTWICE_ADD"] = "elementwise_add";
    HAILO_LAYER_TYPES["ELEMENTWICE_SUB"] = "elementwise_sub";
    HAILO_LAYER_TYPES["ELEMENTWICE_MULT"] = "elementwise_mult";
    HAILO_LAYER_TYPES["ELEMENTWICE_MUL"] = "elementwise_mul";
    HAILO_LAYER_TYPES["MATMUL"] = "matmul";
    HAILO_LAYER_TYPES["AVGPOOL"] = "avgpool";
    HAILO_LAYER_TYPES["MAXPOOL"] = "maxpool";
    HAILO_LAYER_TYPES["REDUCE_SUM"] = "reduce_sum";
    HAILO_LAYER_TYPES["REDUCE_MAX"] = "reduce_max";
    HAILO_LAYER_TYPES["ARGMAX"] = "argmax";
    HAILO_LAYER_TYPES["SOFTMAX"] = "softmax";
    HAILO_LAYER_TYPES["OTHERS"] = "others";
    HAILO_LAYER_TYPES["CONCAT"] = "concat";
    HAILO_LAYER_TYPES["FEATURE_SPLITTER"] = "feature_splitter";
    HAILO_LAYER_TYPES["FEATURE_SHUFFLE"] = "feature_shuffle";
    HAILO_LAYER_TYPES["SLICE"] = "slice";
    HAILO_LAYER_TYPES["DEPTH_TO_SPACE"] = "depth_to_space";
    HAILO_LAYER_TYPES["SPACE_TO_DEPTH"] = "space_to_depth";
    HAILO_LAYER_TYPES["INPUT"] = "input";
    HAILO_LAYER_TYPES["CONTEXT_INPUT"] = "context_input";
    HAILO_LAYER_TYPES["CONTEXT_OUTPUT"] = "context_output";
    HAILO_LAYER_TYPES["INPUT_LAYER"] = "input_layer";
    HAILO_LAYER_TYPES["OUTPUT"] = "output";
    HAILO_LAYER_TYPES["OUTPUT_LAYER"] = "output_layer";
    HAILO_LAYER_TYPES["CONTEXT"] = "context";
    HAILO_LAYER_TYPES["CONST_INPUT"] = "const_input";
})(HAILO_LAYER_TYPES || (exports.HAILO_LAYER_TYPES = HAILO_LAYER_TYPES = {}));
var ONNX_LAYER_TYPES;
(function (ONNX_LAYER_TYPES) {
    ONNX_LAYER_TYPES["RELU6"] = "Relu6";
    ONNX_LAYER_TYPES["INPUT"] = "input";
    ONNX_LAYER_TYPES["AVERAGE_POOL_2D"] = "AveragePool";
    ONNX_LAYER_TYPES["MAX_POOL_2D"] = "MaxPool";
    ONNX_LAYER_TYPES["GLOBAL_AVERAGE_POOL_2D"] = "GlobalAveragePool";
    ONNX_LAYER_TYPES["GLOBAL_MAX_POOL_2D"] = "GlobalMaxPool";
    ONNX_LAYER_TYPES["MEAN"] = "Mean";
    ONNX_LAYER_TYPES["REDUCE_MEAN"] = "ReduceMean";
    ONNX_LAYER_TYPES["REDUCE_L2"] = "ReduceL2";
    ONNX_LAYER_TYPES["CONCAT"] = "Concat";
    ONNX_LAYER_TYPES["CONV_2D"] = "Conv";
    ONNX_LAYER_TYPES["TRANSPOSE_CONV"] = "ConvTranspose";
    ONNX_LAYER_TYPES["GEMM"] = "Gemm";
    ONNX_LAYER_TYPES["MATMUL"] = "MatMul";
    ONNX_LAYER_TYPES["BATCH_NORMALIZATION"] = "BatchNormalization";
    ONNX_LAYER_TYPES["RELU"] = "Relu";
    ONNX_LAYER_TYPES["ELU"] = "Elu";
    ONNX_LAYER_TYPES["LEAKY_RELU"] = "LeakyRelu";
    ONNX_LAYER_TYPES["EXP"] = "Exp";
    ONNX_LAYER_TYPES["SIGMOID"] = "Sigmoid";
    ONNX_LAYER_TYPES["CLIP"] = "Clip";
    ONNX_LAYER_TYPES["TANH"] = "Tanh";
    ONNX_LAYER_TYPES["ABS"] = "Abs";
    ONNX_LAYER_TYPES["SIGN"] = "Sign";
    ONNX_LAYER_TYPES["GREATER"] = "Greater";
    ONNX_LAYER_TYPES["PRELU"] = "PRelu";
    ONNX_LAYER_TYPES["SOFT_PLUS"] = "Softplus";
    ONNX_LAYER_TYPES["ERF"] = "Erf";
    ONNX_LAYER_TYPES["SQRT"] = "Sqrt";
    ONNX_LAYER_TYPES["LESS"] = "Less";
    ONNX_LAYER_TYPES["LOG"] = "Log";
    ONNX_LAYER_TYPES["HARD_SIGMOID"] = "HardSigmoid";
    ONNX_LAYER_TYPES["MIN"] = "Min";
    ONNX_LAYER_TYPES["MAX"] = "Max";
    ONNX_LAYER_TYPES["HARD_SWISH"] = "HardSwish";
    ONNX_LAYER_TYPES["SOFT_SIGN"] = "SoftSign";
    ONNX_LAYER_TYPES["RECIPROCAL"] = "Reciprocal";
    ONNX_LAYER_TYPES["RESIZE"] = "Resize";
    ONNX_LAYER_TYPES["UPSAMPLE"] = "Upsample";
    ONNX_LAYER_TYPES["RESHAPE"] = "Reshape";
    ONNX_LAYER_TYPES["TRANSPOSE"] = "Transpose";
    ONNX_LAYER_TYPES["FLATTEN"] = "Flatten";
    ONNX_LAYER_TYPES["SOFTMAX"] = "Softmax";
    ONNX_LAYER_TYPES["ARG_MAX"] = "ArgMax";
    ONNX_LAYER_TYPES["PAD"] = "Pad";
    ONNX_LAYER_TYPES["SHAPE"] = "Shape";
    ONNX_LAYER_TYPES["CONSTANT"] = "Constant";
    ONNX_LAYER_TYPES["CONSTANT_OF_SHAPE"] = "ConstantOfShape";
    ONNX_LAYER_TYPES["GATHER"] = "Gather";
    ONNX_LAYER_TYPES["SQUEEZE"] = "Squeeze";
    ONNX_LAYER_TYPES["UNSQUEEZE"] = "Unsqueeze";
    ONNX_LAYER_TYPES["EXPAND"] = "Expand";
    ONNX_LAYER_TYPES["TILE"] = "Tile";
    ONNX_LAYER_TYPES["DROPOUT"] = "Dropout";
    ONNX_LAYER_TYPES["SLICE"] = "Slice";
    ONNX_LAYER_TYPES["SPLIT"] = "Split";
    ONNX_LAYER_TYPES["POW"] = "Pow";
    ONNX_LAYER_TYPES["CAST"] = "Cast";
    ONNX_LAYER_TYPES["FLOOR"] = "Floor";
    ONNX_LAYER_TYPES["REDUCE_MAX"] = "ReduceMax";
    ONNX_LAYER_TYPES["REDUCE_SUM"] = "ReduceSum";
    ONNX_LAYER_TYPES["REDUCE_SUM_SQUARE"] = "ReduceSumSquare";
    ONNX_LAYER_TYPES["ADD"] = "Add";
    ONNX_LAYER_TYPES["SUM"] = "Sum";
    ONNX_LAYER_TYPES["SUB"] = "Sub";
    ONNX_LAYER_TYPES["NEG"] = "Neg";
    ONNX_LAYER_TYPES["DIV"] = "Div";
    ONNX_LAYER_TYPES["MUL"] = "Mul";
    ONNX_LAYER_TYPES["EQUAL"] = "Equal";
    ONNX_LAYER_TYPES["DEPTH_TO_SPACE"] = "DepthToSpace";
    ONNX_LAYER_TYPES["SPACE_TO_DEPTH"] = "SpaceToDepth";
    ONNX_LAYER_TYPES["WHERE"] = "Where";
    ONNX_LAYER_TYPES["INSTANCE_NORMALIZATION"] = "InstanceNormalization";
    ONNX_LAYER_TYPES["LAYER_NORMALIZATION"] = "LayerNormalization";
    ONNX_LAYER_TYPES["IDENTITY"] = "Identity";
    ONNX_LAYER_TYPES["EINSUM"] = "Einsum";
    ONNX_LAYER_TYPES["RNN"] = "RNN";
    ONNX_LAYER_TYPES["ONE_HOT"] = "OneHot";
    ONNX_LAYER_TYPES["LSTM"] = "LSTM";
    ONNX_LAYER_TYPES["NMS"] = "NonMaxSuppression";
    ONNX_LAYER_TYPES["LOG_SOFTMAX"] = "LogSoftmax";
    ONNX_LAYER_TYPES["NORMALIZATION"] = "Normalization";
})(ONNX_LAYER_TYPES || (exports.ONNX_LAYER_TYPES = ONNX_LAYER_TYPES = {}));
var TFLITE_FRONTEND_LAYER_TYPES;
(function (TFLITE_FRONTEND_LAYER_TYPES) {
    TFLITE_FRONTEND_LAYER_TYPES["RELU6"] = "Relu6";
    TFLITE_FRONTEND_LAYER_TYPES["NORMALIZATION"] = "Normalization";
    TFLITE_FRONTEND_LAYER_TYPES["BATCH_NORM"] = "BatchNorm";
    TFLITE_FRONTEND_LAYER_TYPES["INPUT"] = "input";
    TFLITE_FRONTEND_LAYER_TYPES["AVERAGE_POOL_2D"] = "AveragePool2D";
    TFLITE_FRONTEND_LAYER_TYPES["MAX_POOL_2D"] = "MaxPool2D";
    TFLITE_FRONTEND_LAYER_TYPES["MEAN"] = "Mean";
    TFLITE_FRONTEND_LAYER_TYPES["CONCATENATION"] = "Concatenation";
    TFLITE_FRONTEND_LAYER_TYPES["CONV_2D"] = "Conv2D";
    TFLITE_FRONTEND_LAYER_TYPES["DEPTHWISE_CONV_2D"] = "DepthwiseConv2D";
    TFLITE_FRONTEND_LAYER_TYPES["TRANSPOSE_CONV"] = "TransposeConv";
    TFLITE_FRONTEND_LAYER_TYPES["FULLY_CONNECTED"] = "FullyConnected";
    TFLITE_FRONTEND_LAYER_TYPES["L2_NORMALIZATION"] = "L2Normalization";
    TFLITE_FRONTEND_LAYER_TYPES["RELU"] = "Relu";
    TFLITE_FRONTEND_LAYER_TYPES["RELU_6"] = "Relu6";
    TFLITE_FRONTEND_LAYER_TYPES["TANH"] = "Tanh";
    TFLITE_FRONTEND_LAYER_TYPES["EXP"] = "Exp";
    TFLITE_FRONTEND_LAYER_TYPES["PRELU"] = "PRelu";
    TFLITE_FRONTEND_LAYER_TYPES["LESS"] = "Less";
    TFLITE_FRONTEND_LAYER_TYPES["SQRT"] = "SQRT";
    TFLITE_FRONTEND_LAYER_TYPES["LEAKY_RELU"] = "LeakyRelu";
    TFLITE_FRONTEND_LAYER_TYPES["ABS"] = "Abs";
    TFLITE_FRONTEND_LAYER_TYPES["ELU"] = "Elu";
    TFLITE_FRONTEND_LAYER_TYPES["HARD_SWISH"] = "HardSwish";
    TFLITE_FRONTEND_LAYER_TYPES["LOGISTIC"] = "Logistic";
    TFLITE_FRONTEND_LAYER_TYPES["LOG"] = "Log";
    TFLITE_FRONTEND_LAYER_TYPES["GREATER"] = "Greater";
    TFLITE_FRONTEND_LAYER_TYPES["RESIZE_BILINEAR"] = "ResizeBilinear";
    TFLITE_FRONTEND_LAYER_TYPES["RESIZE_NEAREST_NEIGHBOR"] = "ResizeNearestNeighbor";
    TFLITE_FRONTEND_LAYER_TYPES["RESHAPE"] = "Reshape";
    TFLITE_FRONTEND_LAYER_TYPES["TRANSPOSE"] = "Transpose";
    TFLITE_FRONTEND_LAYER_TYPES["SOFTMAX"] = "Softmax";
    TFLITE_FRONTEND_LAYER_TYPES["ARG_MAX"] = "ArgMax";
    TFLITE_FRONTEND_LAYER_TYPES["PAD"] = "Pad";
    TFLITE_FRONTEND_LAYER_TYPES["PADV2"] = "PadV2";
    TFLITE_FRONTEND_LAYER_TYPES["SHAPE"] = "Shape";
    TFLITE_FRONTEND_LAYER_TYPES["GATHER"] = "Gather";
    TFLITE_FRONTEND_LAYER_TYPES["SQUEEZE"] = "Squeeze";
    TFLITE_FRONTEND_LAYER_TYPES["EXPAND_DIMS"] = "EexpandDims";
    TFLITE_FRONTEND_LAYER_TYPES["TILE"] = "Tile";
    TFLITE_FRONTEND_LAYER_TYPES["PACK"] = "Pack";
    TFLITE_FRONTEND_LAYER_TYPES["UNPACK"] = "Unpack";
    TFLITE_FRONTEND_LAYER_TYPES["SLICE"] = "Slice";
    TFLITE_FRONTEND_LAYER_TYPES["STRIDED_SLICE"] = "StridedSlice";
    TFLITE_FRONTEND_LAYER_TYPES["SPLIT"] = "Split";
    TFLITE_FRONTEND_LAYER_TYPES["SPLIT_V"] = "SplitV";
    TFLITE_FRONTEND_LAYER_TYPES["POW"] = "Pow";
    TFLITE_FRONTEND_LAYER_TYPES["SQUARE"] = "Square";
    TFLITE_FRONTEND_LAYER_TYPES["CAST"] = "Cast";
    TFLITE_FRONTEND_LAYER_TYPES["FLOOR"] = "Floor";
    TFLITE_FRONTEND_LAYER_TYPES["REDUCE_MAX"] = "ReduceMax";
    TFLITE_FRONTEND_LAYER_TYPES["ADD"] = "Add";
    TFLITE_FRONTEND_LAYER_TYPES["ADD_N"] = "AddN";
    TFLITE_FRONTEND_LAYER_TYPES["SUB"] = "Sub";
    TFLITE_FRONTEND_LAYER_TYPES["NEG"] = "Neg";
    TFLITE_FRONTEND_LAYER_TYPES["DIV"] = "Div";
    TFLITE_FRONTEND_LAYER_TYPES["MUL"] = "Mul";
    TFLITE_FRONTEND_LAYER_TYPES["MINIMUM"] = "Minimum";
    TFLITE_FRONTEND_LAYER_TYPES["MAXIMUM"] = "Maximum";
    TFLITE_FRONTEND_LAYER_TYPES["SUM"] = "Sum";
    TFLITE_FRONTEND_LAYER_TYPES["DEQUANTIZE"] = "Dequantize";
    TFLITE_FRONTEND_LAYER_TYPES["DEPTH_TO_SPACE"] = "DepthToSpace";
    TFLITE_FRONTEND_LAYER_TYPES["SPACE_TO_DEPTH"] = "SpaceToDepth";
    TFLITE_FRONTEND_LAYER_TYPES["SIGN"] = "Sign";
    TFLITE_FRONTEND_LAYER_TYPES["FLEX_SIGN"] = "FlexSign";
    TFLITE_FRONTEND_LAYER_TYPES["EQUAL"] = "Equal";
})(TFLITE_FRONTEND_LAYER_TYPES || (exports.TFLITE_FRONTEND_LAYER_TYPES = TFLITE_FRONTEND_LAYER_TYPES = {}));
var TFLITE_BACKEND_LAYER_TYPES;
(function (TFLITE_BACKEND_LAYER_TYPES) {
    TFLITE_BACKEND_LAYER_TYPES["INPUT"] = "input";
    TFLITE_BACKEND_LAYER_TYPES["BATCH_NORM"] = "BATCH_NORM";
    TFLITE_BACKEND_LAYER_TYPES["NORMALIZATION"] = "NORMALIZATION";
    TFLITE_BACKEND_LAYER_TYPES["AVERAGE_POOL_2D"] = "AVERAGE_POOL_2D";
    TFLITE_BACKEND_LAYER_TYPES["MAX_POOL_2D"] = "MAX_POOL_2D";
    TFLITE_BACKEND_LAYER_TYPES["MEAN"] = "MEAN";
    TFLITE_BACKEND_LAYER_TYPES["CONCATENATION"] = "CONCATENATION";
    TFLITE_BACKEND_LAYER_TYPES["CONV_2D"] = "CONV_2D";
    TFLITE_BACKEND_LAYER_TYPES["DEPTHWISE_CONV_2D"] = "DEPTHWISE_CONV_2D";
    TFLITE_BACKEND_LAYER_TYPES["TRANSPOSE_CONV"] = "TRANSPOSE_CONV";
    TFLITE_BACKEND_LAYER_TYPES["FULLY_CONNECTED"] = "FULLY_CONNECTED";
    TFLITE_BACKEND_LAYER_TYPES["L2_NORMALIZATION"] = "L2_NORMALIZATION";
    TFLITE_BACKEND_LAYER_TYPES["RELU"] = "RELU";
    TFLITE_BACKEND_LAYER_TYPES["RELU6"] = "RELU6";
    TFLITE_BACKEND_LAYER_TYPES["TANH"] = "TANH";
    TFLITE_BACKEND_LAYER_TYPES["EXP"] = "EXP";
    TFLITE_BACKEND_LAYER_TYPES["PRELU"] = "PRELU";
    TFLITE_BACKEND_LAYER_TYPES["LESS"] = "LESS";
    TFLITE_BACKEND_LAYER_TYPES["SQRT"] = "SQRT";
    TFLITE_BACKEND_LAYER_TYPES["LEAKY_RELU"] = "LEAKY_RELU";
    TFLITE_BACKEND_LAYER_TYPES["ABS"] = "ABS";
    TFLITE_BACKEND_LAYER_TYPES["ELU"] = "ELU";
    TFLITE_BACKEND_LAYER_TYPES["HARD_SWISH"] = "HARD_SWISH";
    TFLITE_BACKEND_LAYER_TYPES["LOGISTIC"] = "LOGISTIC";
    TFLITE_BACKEND_LAYER_TYPES["LOG"] = "LOG";
    TFLITE_BACKEND_LAYER_TYPES["GREATER"] = "GREATER";
    TFLITE_BACKEND_LAYER_TYPES["RESIZE_BILINEAR"] = "RESIZE_BILINEAR";
    TFLITE_BACKEND_LAYER_TYPES["RESIZE_NEAREST_NEIGHBOR"] = "RESIZE_NEAREST_NEIGHBOR";
    TFLITE_BACKEND_LAYER_TYPES["RESHAPE"] = "RESHAPE";
    TFLITE_BACKEND_LAYER_TYPES["TRANSPOSE"] = "TRANSPOSE";
    TFLITE_BACKEND_LAYER_TYPES["SOFTMAX"] = "SOFTMAX";
    TFLITE_BACKEND_LAYER_TYPES["ARG_MAX"] = "ARG_MAX";
    TFLITE_BACKEND_LAYER_TYPES["PAD"] = "PAD";
    TFLITE_BACKEND_LAYER_TYPES["PADV2"] = "PADV2";
    TFLITE_BACKEND_LAYER_TYPES["SHAPE"] = "SHAPE";
    TFLITE_BACKEND_LAYER_TYPES["GATHER"] = "GATHER";
    TFLITE_BACKEND_LAYER_TYPES["SQUEEZE"] = "SQUEEZE";
    TFLITE_BACKEND_LAYER_TYPES["EXPAND_DIMS"] = "EXPAND_DIMS";
    TFLITE_BACKEND_LAYER_TYPES["TILE"] = "TILE";
    TFLITE_BACKEND_LAYER_TYPES["PACK"] = "PACK";
    TFLITE_BACKEND_LAYER_TYPES["UNPACK"] = "UNPACK";
    TFLITE_BACKEND_LAYER_TYPES["SLICE"] = "SLICE";
    TFLITE_BACKEND_LAYER_TYPES["STRIDED_SLICE"] = "STRIDED_SLICE";
    TFLITE_BACKEND_LAYER_TYPES["SPLIT"] = "SPLIT";
    TFLITE_BACKEND_LAYER_TYPES["SPLIT_V"] = "SPLIT_V";
    TFLITE_BACKEND_LAYER_TYPES["POW"] = "POW";
    TFLITE_BACKEND_LAYER_TYPES["SQUARE"] = "SQUARE";
    TFLITE_BACKEND_LAYER_TYPES["CAST"] = "CAST";
    TFLITE_BACKEND_LAYER_TYPES["FLOOR"] = "FLOOR";
    TFLITE_BACKEND_LAYER_TYPES["REDUCE_MAX"] = "REDUCE_MAX";
    TFLITE_BACKEND_LAYER_TYPES["ADD"] = "ADD";
    TFLITE_BACKEND_LAYER_TYPES["ADD_N"] = "ADD_N";
    TFLITE_BACKEND_LAYER_TYPES["SUB"] = "SUB";
    TFLITE_BACKEND_LAYER_TYPES["NEG"] = "NEG";
    TFLITE_BACKEND_LAYER_TYPES["DIV"] = "DIV";
    TFLITE_BACKEND_LAYER_TYPES["MUL"] = "MUL";
    TFLITE_BACKEND_LAYER_TYPES["MINIMUM"] = "MINIMUM";
    TFLITE_BACKEND_LAYER_TYPES["MAXIMUM"] = "MAXIMUM";
    TFLITE_BACKEND_LAYER_TYPES["SUM"] = "SUM";
    TFLITE_BACKEND_LAYER_TYPES["DEQUANTIZE"] = "DEQUANTIZE";
    TFLITE_BACKEND_LAYER_TYPES["DEPTH_TO_SPACE"] = "DEPTH_TO_SPACE";
    TFLITE_BACKEND_LAYER_TYPES["SPACE_TO_DEPTH"] = "SPACE_TO_DEPTH";
    TFLITE_BACKEND_LAYER_TYPES["SIGN"] = "SIGN";
    TFLITE_BACKEND_LAYER_TYPES["FLEX_SIGN"] = "FLEX_SIGN";
    TFLITE_BACKEND_LAYER_TYPES["EQUAL"] = "EQUAL";
})(TFLITE_BACKEND_LAYER_TYPES || (exports.TFLITE_BACKEND_LAYER_TYPES = TFLITE_BACKEND_LAYER_TYPES = {}));
var BASIC_NODE_TYPES;
(function (BASIC_NODE_TYPES) {
    BASIC_NODE_TYPES["DEFAULT"] = "default";
    BASIC_NODE_TYPES["FORMAT_CHANGE"] = "format_change";
    BASIC_NODE_TYPES["COMPUTE_INTENSE"] = "compute_intense";
    BASIC_NODE_TYPES["DIMENSION_CHANGE"] = "dimension_change";
    BASIC_NODE_TYPES["ACTIVATION"] = "activation";
    BASIC_NODE_TYPES["REORDERING"] = "reordering";
    BASIC_NODE_TYPES["INPUT"] = "input";
    BASIC_NODE_TYPES["OUTPUT"] = "output";
    BASIC_NODE_TYPES["CONTEXT"] = "context";
    BASIC_NODE_TYPES["CONTEXT_INPUT"] = "context_input";
    BASIC_NODE_TYPES["CONTEXT_OUTPUT"] = "context_output";
})(BASIC_NODE_TYPES || (exports.BASIC_NODE_TYPES = BASIC_NODE_TYPES = {}));
exports.PROJECT_FILE_CONFIG = {
    EXTENSION: 'dfc',
    ENCODING: 'utf8',
};
exports.LOG_FILE_NAME = 'hailo_sdk.client.log';
