"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
const decompress_1 = __importDefault(require("decompress"));
const parsing_services_1 = __importDefault(require("../services/parsing.services"));
const getFilePathByExtension_1 = __importDefault(require("../helpers/getFilePathByExtension"));
const getFileExtensionFromPath_1 = __importDefault(require("../utils/getFileExtensionFromPath"));
const mapHarLayerToHailoNode_1 = __importDefault(require("../mappers/mapHarLayerToHailoNode"));
const reduceHarLayersToHailoEdges_1 = __importDefault(require("../reducers/reduceHarLayersToHailoEdges"));
const getTempDirLocation_1 = __importDefault(require("../utils/getTempDirLocation"));
const removeProjectFiles_1 = __importDefault(require("../helpers/removeProjectFiles"));
const MODEL_FILE_EXTENSION = 'hn';
const METADATA_FILE_EXTENSION = 'json';
exports.default = {
    parse: (req, res) => __awaiter(void 0, void 0, void 0, function* () {
        const { params: { id }, } = req;
        const { body: { modelExtension, hwArchitecture, startNodeNames, endNodeNames, modelName }, } = req;
        try {
            const path = `${(0, getTempDirLocation_1.default)()}/${id}/${modelName}`;
            const response = yield parsing_services_1.default.parseModel({
                path,
                id,
                modelExtension,
                hwArchitecture,
                startNodeNames: JSON.parse(startNodeNames),
                endNodeNames: JSON.parse(endNodeNames),
                modelName,
            });
            return res.status(200).send(response);
        }
        catch (error) {
            (0, removeProjectFiles_1.default)(id);
            const { message } = error;
            return res.status(500).send({ status: 'error', message: `error of parse - ${message}` });
        }
    }),
    delete: (req, res) => __awaiter(void 0, void 0, void 0, function* () {
        const { params: { id }, } = req;
        try {
            const dir = `${(0, getTempDirLocation_1.default)()}/${id}`;
            fs_1.default.rmSync(dir, { recursive: true, force: true });
            return res.status(200).send({
                status: 'ok',
                message: 'Project files deleted successfully.',
            });
        }
        catch (error) {
            const { message } = error;
            return res.status(500).send({ status: 'error', message: `error of delete - ${message}` });
        }
    }),
    upload: (_, res) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            return res.status(200).send({
                status: 'ok',
                message: 'Project files imported successfully.',
            });
        }
        catch (error) {
            const { message } = error;
            return res.status(500).send({ status: 'error', message: `error of upload - ${message}` });
        }
    }),
    downloadHAR: (req, res) => __awaiter(void 0, void 0, void 0, function* () {
        const { params: { id }, } = req;
        try {
            const tempDirLocation = (0, getTempDirLocation_1.default)();
            const dir = `${tempDirLocation}/${id}`;
            const path = (0, getFilePathByExtension_1.default)(dir, 'har');
            if (path) {
                res.download(path);
            }
            else {
                return res.status(500).send({ message: 'HAR file not found' });
            }
        }
        catch (error) {
            const { message } = error;
            return res.status(500).send({ status: 'error', message: `error of downloadHar - ${message}` });
        }
    }),
    getHailoModel: (req, res) => __awaiter(void 0, void 0, void 0, function* () {
        const { params: { id }, } = req;
        try {
            const tempDirLocation = (0, getTempDirLocation_1.default)();
            const dir = `${tempDirLocation}/${id}`;
            const path = (0, getFilePathByExtension_1.default)(dir, 'har');
            let files;
            let hwArchitecture = null;
            if (!path)
                throw new Error('Folder with hailo model not found');
            try {
                files = yield (0, decompress_1.default)(path, `${dir}/decompressed`);
            }
            catch (_a) {
                throw new Error(`Can't decompress files`);
            }
            const hnFile = files === null || files === void 0 ? void 0 : files.find(file => {
                const extension = (0, getFileExtensionFromPath_1.default)(file.path);
                return extension === MODEL_FILE_EXTENSION;
            });
            if (!hnFile)
                throw new Error(`HN file not found`);
            const hnJSON = JSON.parse(hnFile.data.toString());
            files.forEach(file => {
                const extension = (0, getFileExtensionFromPath_1.default)(file.path);
                if (extension === METADATA_FILE_EXTENSION) {
                    const { hw_arch } = JSON.parse(file.data.toString());
                    if (hw_arch) {
                        hwArchitecture = hw_arch;
                    }
                }
            });
            try {
                fs_1.default.rmSync(`${dir}/decompressed`, { recursive: true, force: true });
            }
            catch (err) {
                throw new Error(`Can't delete decompressed files`);
            }
            try {
                const nodes = Object.entries((hnJSON === null || hnJSON === void 0 ? void 0 : hnJSON.layers) || {}).map(mapHarLayerToHailoNode_1.default) || [];
                const edges = Object.entries((hnJSON === null || hnJSON === void 0 ? void 0 : hnJSON.layers) || {}).reduce(reduceHarLayersToHailoEdges_1.default, []);
                const response = {
                    hailoModel: {
                        nodes,
                        edges,
                    },
                    hwArchitecture,
                };
                (0, removeProjectFiles_1.default)(id);
                return res.status(200).send(response);
            }
            catch (_b) {
                throw new Error(`Can't parse layers`);
            }
        }
        catch (error) {
            (0, removeProjectFiles_1.default)(id);
            const { message } = error;
            return res.status(500).send({ status: 'error', message });
        }
    }),
};
