"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const getFileNameFromPath_1 = __importDefault(require("../utils/getFileNameFromPath"));
const getBackendParserCommand = (format, path, hwArchitecture, modelFileName, startNodeNames, endNodeNames, projectFilesDirectory) => {
    const name = (0, getFileNameFromPath_1.default)(path);
    return `hailo parser ${format} ${path} ${projectFilesDirectory ? ` --har-path ${projectFilesDirectory}/${modelFileName}` : ''}${hwArchitecture ? ` --hw-arch ${hwArchitecture}` : ''}${(startNodeNames === null || startNodeNames === void 0 ? void 0 : startNodeNames.length) ? ` --start-node-names ${startNodeNames.join(' ')}` : ''}${(endNodeNames === null || endNodeNames === void 0 ? void 0 : endNodeNames.length) ? ` --end-node-names ${endNodeNames.join(' ')}` : ''} --parsing-report-path ${projectFilesDirectory}/${name}.json -y`;
};
exports.default = getBackendParserCommand;
