"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const getBackendParserModelFormat = (modelFileExtension) => {
    switch (modelFileExtension) {
        case constants_1.MODEL_FILE_EXTENSIONS.TFLITE:
            return constants_1.BACKEND_PARSER_MODEL_FORMATS.TF;
        case constants_1.MODEL_FILE_EXTENSIONS.ONNX:
            return constants_1.BACKEND_PARSER_MODEL_FORMATS.ONNX;
        default:
            return constants_1.BACKEND_PARSER_MODEL_FORMATS.ONNX;
    }
};
exports.default = getBackendParserModelFormat;
