"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const getCustomTypeFromBackendTFLiteType = (type) => {
    let result = constants_1.BASIC_NODE_TYPES.DEFAULT;
    if ([constants_1.TFLITE_BACKEND_LAYER_TYPES.RESIZE_BILINEAR, constants_1.TFLITE_BACKEND_LAYER_TYPES.RESIZE_NEAREST_NEIGHBOR].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.FORMAT_CHANGE;
    }
    else if ([
        constants_1.TFLITE_BACKEND_LAYER_TYPES.NORMALIZATION,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.BATCH_NORM,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.L2_NORMALIZATION,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.DEFAULT;
    }
    else if ([
        constants_1.TFLITE_BACKEND_LAYER_TYPES.CONV_2D,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.DEPTHWISE_CONV_2D,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.TRANSPOSE_CONV,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.FULLY_CONNECTED,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.ADD,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SUB,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.NEG,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.DIV,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.MUL,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.MINIMUM,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.MAXIMUM,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.COMPUTE_INTENSE;
    }
    else if ([
        constants_1.TFLITE_BACKEND_LAYER_TYPES.AVERAGE_POOL_2D,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.MAX_POOL_2D,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SUM,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.MEAN,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.REDUCE_MAX,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.ARG_MAX,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.DIMENSION_CHANGE;
    }
    else if ([
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SOFTMAX,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.RELU,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.RELU6,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.TANH,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.EXP,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.PRELU,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.LESS,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SQRT,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.LEAKY_RELU,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.ABS,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.ELU,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.HARD_SWISH,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.LOGISTIC,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.LOG,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.GREATER,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.ACTIVATION;
    }
    else if ([
        constants_1.TFLITE_BACKEND_LAYER_TYPES.CONCATENATION,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SPLIT,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SPLIT_V,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SLICE,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.STRIDED_SLICE,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.DEPTH_TO_SPACE,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.SPACE_TO_DEPTH,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.RESHAPE,
        constants_1.TFLITE_BACKEND_LAYER_TYPES.TRANSPOSE,
    ].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.REORDERING;
    }
    else if ([constants_1.TFLITE_BACKEND_LAYER_TYPES.INPUT].includes(type)) {
        result = constants_1.BASIC_NODE_TYPES.INPUT;
    }
    return result;
};
exports.default = getCustomTypeFromBackendTFLiteType;
